/*!
	@file   base64.h
	@brief  <brief description here>
	@t.odo	-
	---------------------------------------------------------------------------

	MIT License
*/
/******************************************************************************
* Preprocessor Definitions & Macros
******************************************************************************/

#ifndef LIB_BASE64_H_
#define LIB_BASE64_H_

/******************************************************************************
* Includes
******************************************************************************/

#include <inttypes.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>

/******************************************************************************
* MACROS
******************************************************************************/

#define BASE64_ENCODE_OUT_SIZE(s) ((uint32_t)((((s) + 2) / 3) * 4 + 1))
#define BASE64_DECODE_OUT_SIZE(s) ((uint32_t)(((s) / 4) * 3))

/******************************************************************************
* Enumerations, structures & Variables
******************************************************************************/

/******************************************************************************
* Declaration | Public Functions
******************************************************************************/

uint32_t base64_encode(uint8_t *in, size_t inlen, uint8_t *out);
uint32_t base64_decode(uint8_t *in, size_t inlen, uint8_t *out);
			     
/******************************************************************************
* EOF - NO CODE AFTER THIS LINE
******************************************************************************/
#endif
