/*!
	@file   tsk_app.c
	@brief  <brief description here>
	@t.odo	-
	---------------------------------------------------------------------------
*/
/******************************************************************************
* Preprocessor Definitions & Macros
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/

#include "tsk_app.h"

/******************************************************************************
* Enumerations, structures & Variables
******************************************************************************/

static osThreadId_t tsk_app_handle;

const osThreadAttr_t tsk_app_attrs =
{
	.name = "TskApp",
	.priority = (osPriority_t) osPriorityLow5,
	.stack_size = 2048
};

static TickType_t x_last_waketime;

///////////////////////////////////////////////////////////////////////////////

static uint8_t data[64];

/******************************************************************************
* Declaration | Static Functions
******************************************************************************/

/******************************************************************************
* Definition  | Static Functions
******************************************************************************/

/******************************************************************************
* Definition  | Public Functions
******************************************************************************/

i_status tsk_app_start()
{
	tsk_app_handle = osThreadNew(tsk_app, NULL, &tsk_app_attrs);
	return I_OK;
}

/******************************************************************************
* -- Main Task
******************************************************************************/	

void tsk_app(void *argument)
{
	#ifdef HAL_IWDG_MODULE_ENABLED
	HAL_IWDG_Refresh(&hiwdg);
	#endif

	for(int i=0;i<64;i++)
		data[i]=i;

	flash_erase(0x8020000, 0x8020000+FLASH_SECTION_SIZE);
	flash_write(0x8020000, data, 64);

	while(1)
	{
		vTaskDelayUntil( &x_last_waketime, 5);
	}
}

/******************************************************************************
* EOF - NO CODE AFTER THIS LINE
******************************************************************************/
